/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.gui.GUIBaseManager;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.pets.PetEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GUIPetList
extends GuiScrollingList {
    GUIBaseManager parentGUI;
    List<PetEntry> petList = new ArrayList<PetEntry>();

    public GUIPetList(GUIBaseManager parentGUI, ExtendedPlayer playerExt, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 28);
        this.parentGUI = parentGUI;
        this.petList = playerExt.petManager.getEntryList(parentGUI.type);
    }

    protected int getSize() {
        return this.petList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGUI.selectPet(this.petList.get(index));
    }

    protected boolean isSelected(int index) {
        return this.parentGUI.getSelectedPet() != null && this.parentGUI.getSelectedPet().equals(this.petList.get(index));
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        PetEntry petEntry = this.petList.get(index);
        MobInfo mobInfo = petEntry.getMobInfo();
        if (mobInfo == null) {
            return;
        }
        int boxLeft = this.left;
        int levelBarWidth = 9;
        int levelBarHeight = 9;
        int levelBarX = boxLeft + 20;
        int levelBarY = boxTop + boxBottom - levelBarHeight - 4;
        int levelBarU = 256 - levelBarWidth;
        int levelBarV = 256 - levelBarHeight;
        int level = mobInfo.summonCost;
        if (petEntry.spawningActive) {
            if (this.isSelected(index)) {
                super.drawGradientRect(boxLeft, boxTop, boxRight, boxBottom, 0x99FFEE, 0x99FFEE);
            }
            super.drawGradientRect(boxLeft, boxTop, boxRight, boxBottom, 0x448877, 0x448877);
            levelBarU -= levelBarWidth;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            this.parentGUI.func_73729_b(levelBarX + levelBarWidth * currentLevel, levelBarY, levelBarU, levelBarV, levelBarWidth, levelBarHeight);
        }
        this.parentGUI.getFontRenderer().func_78276_b(petEntry.getDisplayName(), boxLeft + 20, boxTop + 2, 0xFFFFFF);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mobInfo.getIcon());
        this.parentGUI.drawTexturedModalRect(this.left + 2, boxTop + 4, 0, 0, 16, 16, 16);
    }
}

